#!/bin/bash

echo "🚀 Starting Project Setup..."

# ==========================================
# 1. Check for Homebrew (Abort if missing)
# ==========================================
if ! command -v brew &>/dev/null; then
	echo "❌ Error: Homebrew is not installed."
	echo "Please install Homebrew (https://brew.sh) and run this script again."
	exit 1
fi

# ==========================================
# 2. Check & Install swift-format
# ==========================================
if ! command -v swift-format &>/dev/null; then
	echo "🛠️  swift-format not found. Installing via Homebrew..."
	brew install swift-format
fi

# ==========================================
# 3. Configure Git Hooks
# ==========================================
# Check if the .githooks folder actually exists in the repo
if [ -d ".githooks" ]; then
	# Set the core.hooksPath to the local folder
	git config core.hooksPath .githooks

	# Ensure the pre-commit script is executable
	if [ -f ".githooks/pre-commit" ]; then
		chmod +x .githooks/pre-commit
	fi

	echo "✅ Git hooks configured to use local .githooks folder."
else
	echo "⚠️  Error: .githooks directory not found. Skipping hook setup."
	echo "Please ensure you have created the '.githooks' folder and moved your 'pre-commit' script inside."
	exit 1
fi

echo "🎉 Setup Complete! You are ready to code."
