//
//  ViveGlassesConnectSDK_ios_samplesApp.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/10.
//

import SwiftData
import SwiftUI

@main
struct ViveGlassesConnectSDK_ios_samplesApp: App {
    var sharedModelContainer: ModelContainer = {
        let schema = Schema([])
        let modelConfiguration = ModelConfiguration(schema: schema, isStoredInMemoryOnly: false)

        do {
            return try ModelContainer(for: schema, configurations: [modelConfiguration])
        } catch {
            fatalError("Could not create ModelContainer: \(error)")
        }
    }()

    var body: some Scene {
        WindowGroup {
            ZStack {
                ContentView()
                    .preferredColorScheme(.dark)
                ToastView()
            }
        }
        .modelContainer(sharedModelContainer)
    }
}

struct AppRootPreview: View {
    var body: some View {
        ContentView()
            .preferredColorScheme(.dark)
    }
}

#Preview("App Root") {
    AppRootPreview()
}
