//
//  VideoView.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Megan Tsai(蔡靚姚) on 2025/12/29.
//

import AVFoundation
import SwiftUI

struct VideoLayerView: UIViewRepresentable {
    let layer: AVSampleBufferDisplayLayer?

    final class HostView: UIView {
        private var attachedLayer: AVSampleBufferDisplayLayer?

        func attach(_ layer: AVSampleBufferDisplayLayer?) {
            if let old = attachedLayer {
                old.removeFromSuperlayer()
            }
            attachedLayer = layer

            guard let layer else { return }
            self.layer.addSublayer(layer)
            layer.frame = bounds
        }

        override func layoutSubviews() {
            super.layoutSubviews()
            attachedLayer?.frame = bounds
        }
    }

    func makeUIView(context: Context) -> HostView {
        let v = HostView()
        v.backgroundColor = .black
        return v
    }

    func updateUIView(_ uiView: HostView, context: Context) {
        uiView.attach(layer)
    }
}
