//
//  ToggleButton.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/29.
//

import SwiftUI

struct ToggleButton: View {
    let isActive: Bool
    let activeText: String
    let inactiveText: String
    let activeColor: Color
    let inactiveColor: Color
    let isDisabled: Bool
    var isLoading: Bool
    let action: () -> Void

    init(
        isActive: Bool,
        activeText: String,
        inactiveText: String,
        activeColor: Color = .red,
        inactiveColor: Color = .blue,
        isDisabled: Bool = false,
        isLoading: Bool = false,
        action: @escaping () -> Void
    ) {
        self.isActive = isActive
        self.activeText = activeText
        self.inactiveText = inactiveText
        self.activeColor = activeColor
        self.inactiveColor = inactiveColor
        self.isDisabled = isDisabled
        self.isLoading = isLoading
        self.action = action
    }

    var body: some View {
        Button(action: action) {
            HStack {
                Text(isActive ? activeText : inactiveText)
                    .font(.buttonText)
                if isLoading {
                    ProgressView()
                        .progressViewStyle(CircularProgressViewStyle(tint: .white))
                        .scaleEffect(0.8)
                }
            }
            .frame(maxWidth: .infinity)
            .padding(.vertical, 12)
        }
        .buttonStyle(PlainButtonStyle())
        .background(
            isDisabled ? Color.gray.opacity(0.5) : (isActive ? activeColor : inactiveColor)
        )
        .cornerRadius(Layout.cornerRadius)
        .disabled(isDisabled || isLoading)
    }
}
