//
//  ToastView.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Megan Tsai(蔡靚姚) on 2025/12/16.
//

import SwiftUI

struct ToastView: View {
    @StateObject private var manager = ToastManager.shared

    var body: some View {
        ZStack {
            if manager.isShowing {
                VStack {
                    Spacer()
                    Text(manager.message)
                        .font(.system(.body, design: .default))
                        .foregroundColor(.primary)
                        .multilineTextAlignment(.center)
                        .padding(.horizontal, 20)
                        .padding(.vertical, 14)
                        .background(
                            .ultraThinMaterial,
                            in: RoundedRectangle(cornerRadius: 12)
                        )
                        .shadow(color: .black.opacity(0.2), radius: 10, x: 0, y: 5)
                        .padding(.bottom, 150)
                }
                .transition(.opacity)
                .allowsHitTesting(false)
            }
        }
    }
}
