import SwiftUI

enum IconSource {
    case system(String)
    case resource(ImageResource)
}

struct SectionHeader: View {
    let icon: IconSource
    let title: String
    var iconColor: Color = .appTextPrimary

    var body: some View {
        VStack(alignment: .leading, spacing: Layout.spacingLarge) {
            HStack {
                iconView
                    .frame(width: 21, height: 21)

                Text(title)
                    .font(.appHeadline)
                    .foregroundColor(.appTextPrimary)

                Spacer()
            }
            .padding(.top, Layout.padding)

            Divider()
                .frame(height: Layout.dividerHeight)
                .background(Color.appBorder)
        }
    }

    @ViewBuilder
    private var iconView: some View {
        switch icon {
        case .system(let name):
            Image(systemName: name)
                .resizable()
                .foregroundColor(iconColor)
        case .resource(let resource):
            Image(resource)
                .resizable()
                .renderingMode(.template)
                .foregroundColor(iconColor)
        }
    }
}
