//
//  CustomTabView.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/11.
//

import SwiftUI

protocol CustomTabView: View {
    var content: AnyView { get }
}

extension CustomTabView {
    var body: some View {
        content
            .frame(maxWidth: .infinity, maxHeight: .infinity, alignment: .top)
            .padding(.horizontal, Layout.paddingLarge)
            .padding(.top, 84)
            .background(Color.appBackground)
    }
}
