//
//  ActionSection.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/29.
//

import SwiftUI

struct ActionSection<Content: View>: View {
    let title: String
    let content: Content

    init(title: String, @ViewBuilder content: () -> Content) {
        self.title = title
        self.content = content()
    }

    var body: some View {
        VStack(alignment: .leading, spacing: Layout.spacing) {
            Text(title)
                .font(.appSubheadline)
                .foregroundColor(.appTextPrimary)

            content
        }
        .padding(.horizontal, Layout.paddingSmall)
        .padding(.top, Layout.padding)
    }
}
