//
//  AudioTabView.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/11.
//

import SwiftUI

struct AudioTabView: CustomTabView {
    @ObservedObject var viewModel: AudioViewModel
    let enabled: Bool

    var content: AnyView {
        AnyView(
            VStack {
                SectionHeader(icon: .resource(.audioTabAudiocontrol), title: "Audio Control")

                ActionSection(title: "Play Audio") {
                    ToggleButton(
                        isActive: viewModel.isPlaying,
                        activeText: "Stop Sample Audio",
                        inactiveText: "Play Sample Audio",
                        isDisabled: !enabled || viewModel.isRecording,
                        action: { viewModel.togglePlaySample() }
                    )
                }

                ActionSection(title: "Audio Recording") {
                    ToggleButton(
                        isActive: viewModel.isRecording,
                        activeText: "Stop Recording \(formatTime(viewModel.currentTime))",
                        inactiveText: "Start Recording",
                        activeColor: .red,
                        inactiveColor: .green,
                        isDisabled: !enabled || viewModel.isPlaying,
                        isLoading: viewModel.isLoadingRecording,
                        action: { viewModel.toggleRecording() }
                    )

                    if let fileURL = viewModel.recordedFileURL {
                        ShareLink(item: fileURL) {
                            HStack {
                                Image(systemName: "square.and.arrow.up")
                                Text("Share Recording")
                                    .font(.buttonText)
                            }
                            .frame(maxWidth: .infinity)
                            .padding(.vertical, Layout.paddingSmall)
                            .background(Color.blue)
                            .foregroundColor(.white)
                            .cornerRadius(Layout.cornerRadius)
                        }
                    }
                }
            }
        )
    }
}

#Preview {
    struct PreviewContainer: View {
        var body: some View {
            let viewModel = ContentViewModel()
            AudioTabView(viewModel: viewModel.audioVM, enabled: true)
                .background(Color.appBackground)
        }
    }

    return PreviewContainer()
}
