//
//  LogUtil.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/16.
//

import Foundation

enum LogLevel: String {
    case debug = "DEBUG"
    case info = "INFO"
    case warning = "WARNING"
    case error = "ERROR"
}

class LogUtil {
    private static let dateFormatter: DateFormatter = {
        let formatter = DateFormatter()
        formatter.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS"
        return formatter
    }()

    static func log(
        _ tag: String,
        _ message: String,
        level: LogLevel = .info,
    ) {
        let timestamp = dateFormatter.string(from: Date())

        #if DEBUG
            print("\(timestamp) [\(level.rawValue)][\(tag)] \(message)")
        #endif
    }

    static func d(_ tag: String, _ message: String) {
        log(tag, message, level: .debug)
    }

    static func i(_ tag: String, _ message: String) {
        log(tag, message, level: .info)
    }

    static func w(_ tag: String, _ message: String) {
        log(tag, message, level: .warning)
    }

    static func e(_ tag: String, _ message: String) {
        log(tag, message, level: .error)
    }
}
