//
//  AppStyles.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/19.
//

import SwiftUI

// MARK: - Colors
extension Color {
    static let appBackground = Color(hex: "#2A3649") ?? .black
    static let appBorder = Color(hex: "#4B5563")!

    static let appTextPrimary = Color.primary
    static let appTextSecondary = Color.primary.opacity(0.7)
    static let appTextTertiary = Color.gray
}

// MARK: - Typography
extension Font {
    static let appTitle = Font.system(size: 32, weight: .semibold)
    static let appHeadline = Font.system(size: 20, weight: .semibold)
    static let appSubheadline = Font.system(size: 18, weight: .medium)
    static let appBody = Font.system(size: 16, weight: .regular)
    static let appBoldBody = Font.system(size: 16, weight: .bold)
    static let buttonText = Font.system(size: 16, weight: .semibold)
}

// MARK: - Spacing & Layout
enum Layout {
    static let padding: CGFloat = 16
    static let paddingLarge: CGFloat = 24
    static let paddingSmall: CGFloat = 8
    static let spacing: CGFloat = 12
    static let spacingLarge: CGFloat = 24
    static let cornerRadius: CGFloat = 8
    static let dividerHeight: CGFloat = 1.5
}
