//
//  DeviceStatus.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Created by Hank Chiu on 2025/12/10.
//

import Foundation
import ViveGlassKit

struct DeviceStatus {
    let connectionState: ViveGlass.ConnectionState

    var isConnected: Bool {
        switch connectionState {
        case .connected: return true
        default: return false
        }
    }

    static var disconnected: DeviceStatus {
        DeviceStatus(
            connectionState: .disconnected,
        )
    }
}
