//
//  VideoRenderer.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Extracted utility to manage AVSampleBufferDisplayLayer
//

import AVFoundation
import CoreMedia
import Foundation

final class VideoRenderer {
    private(set) var layer: AVSampleBufferDisplayLayer

    init(
        videoGravity: AVLayerVideoGravity = .resizeAspect,
        backgroundColor: CGColor = CGColor(red: 0, green: 0, blue: 0, alpha: 1)
    ) {
        let displayLayer = AVSampleBufferDisplayLayer()
        displayLayer.videoGravity = videoGravity
        displayLayer.backgroundColor = backgroundColor
        displayLayer.preventsDisplaySleepDuringVideoPlayback = true
        self.layer = displayLayer
    }

    func enqueue(_ buffer: CMSampleBuffer) {
        if layer.status == .failed {
            layer.flush()
        }
        layer.enqueue(buffer)
    }

    func flush() {
        layer.flush()
    }

    // attach to synchronizer
    func attach(to synchronizer: AVSampleBufferRenderSynchronizer) {
        synchronizer.addRenderer(layer)
    }

    // detach to synchronizer
    func detach(from synchronizer: AVSampleBufferRenderSynchronizer) {
        synchronizer.removeRenderer(layer, at: .zero)
    }
}
