//
//  AudioPlaybackManager.swift
//  ViveGlassesConnectSDK_ios_samples
//
//  Extracted utility to manage AVAudioSession and AVSampleBufferAudioRenderer
//

import AVFoundation
import CoreMedia
import Foundation

final class AudioRenderer {
    private(set) var renderer: AVSampleBufferAudioRenderer?

    func startSession() throws {
        let session = AVAudioSession.sharedInstance()
        try session.setCategory(.playAndRecord, mode: .videoChat, options: [.defaultToSpeaker])
        try session.setActive(true)
        try? session.overrideOutputAudioPort(.speaker)

        if renderer == nil {
            renderer = AVSampleBufferAudioRenderer()
        }
    }

    func stopSession() {
        try? AVAudioSession.sharedInstance().setActive(false)
        renderer?.flush()
        renderer = nil
    }

    var isReadyForMoreMediaData: Bool {
        renderer?.isReadyForMoreMediaData ?? false
    }

    func flush() {
        renderer?.flush()
    }

    func enqueue(_ buffer: CMSampleBuffer) {
        guard let renderer, renderer.isReadyForMoreMediaData else { return }
        renderer.enqueue(buffer)
    }

    // attach to synchronizer
    func attach(to synchronizer: AVSampleBufferRenderSynchronizer) {
        guard let renderer else { return }
        synchronizer.addRenderer(renderer)
    }

    // detach to synchronizer
    func detach(from synchronizer: AVSampleBufferRenderSynchronizer) {
        guard let renderer else { return }
        synchronizer.removeRenderer(renderer, at: .zero)
    }
}
