package com.htc.viveglass.viveglasssample.ui.tab

import com.htc.viveglass.viveglasssample.R

sealed class AppDestination(
    val route: String,
    val label: String,
    val iconRes: Int
)
{
    data object Glasses : AppDestination("glasses", "Glasses", R.drawable.glasses_solid_full)
    data object Chat : AppDestination("chat","Chat", R.drawable.comment_dots_solid_full)
    data object Audio : AppDestination("audio", "Audio", R.drawable.headphones_solid_full)
    data object Camera : AppDestination("camera", "Camera", R.drawable.camera_solid_full)

    companion object{
        val items = listOf(Glasses, Chat, Audio, Camera)
    }
}
